/** @file sdl_parseopt.h

	Skelton for retropc emulator

	@author Sasaji
	@date   2015.05.18 -

	@brief [ parse options ]
*/

#ifndef SDL_PARSE_OPT_H
#define SDL_PARSE_OPT_H

#include "../../common.h"
#include "../../cchar.h"
#include "../../vm/vm_defs.h"
#include "../parseopt.h"

/// @brief parse command line options
class CParseOptions : public CParseOptionsBase
{
private:
	int get_options(int ac, char *av[]);
	bool get_module_file_name(_TCHAR *path, int size);

	CParseOptions();
	CParseOptions(const CParseOptions &);

public:
	CParseOptions(int ac, char *av[]);
	~CParseOptions();
};

#endif /* SDL_PARSE_OPT_H */
