/** @file labels.h

	Skelton for retropc emulator

	@author Sasaji
	@date   2021.04.18 -

	@brief [ labels ]
*/

#ifndef LABELS_H
#define LABELS_H

#include "common.h"
#include "config.h"
#include "msgs.h"

/// @namespace LABELS
/// @brief Defines Message List for User Interface
namespace LABELS {

extern const CMsg::Id tabs[];

extern const CMsg::Id power_state[];

extern const CMsg::Id io_port[];
extern const uint8_t io_port_pos[];

extern const CMsg::Id sys_mode[];
extern const CMsg::Id fdd_type[];

extern const CMsg::Id correct[];
extern const _TCHAR *correct_amp[];

extern const _TCHAR *wav_sampling_rate[];
extern const _TCHAR *wav_sampling_bits[];

extern const _TCHAR *disp_skew[];

extern CMsg::Id drawing_method[10];
extern uint8_t drawing_method_idx[10];
int MakeDrawingMethodList(uint8_t enable_type);
int GetDrawingMethodIndex(uint8_t drawing_method);

extern const CMsg::Id screen_filter[];

extern const CMsg::Id led_show[];
extern const CMsg::Id led_pos[];

extern const _TCHAR *capture_fmt[];

extern const CMsg::Id sound_samples[];
extern const CMsg::Id sound_late[];

extern const CMsg::Id comm_baud[];

extern const _TCHAR *comm_uart_baudrate[];
extern const _TCHAR *comm_uart_databit[];
extern const CMsg::Id comm_uart_parity[];
extern const _TCHAR *comm_uart_stopbit[];
extern const CMsg::Id comm_uart_flowctrl[];

#if defined(_MBS1)
extern const CMsg::Id exram_size[];
extern const _TCHAR *fmopn_clock[];
extern const CMsg::Id fmopn_irq[];
//extern const CMsg::Id expsg_type[];
extern const CMsg::Id type_of_soundcard[];

#if defined(USE_Z80B_CARD)
extern const CMsg::Id z80bcard_irq[];
#endif
#endif

extern const char *datarec_exts;

extern const char *floppy_disk_exts;
extern const char *blank_floppy_disk_exts;

extern const char *hard_disk_exts;
extern const char *blank_hard_disk_exts;

extern const char *state_file_exts;
extern const char *key_rec_file_exts;

extern const char *autokey_file_exts;
extern const char *printing_file_exts;

extern const CMsg::Id volume[];

extern const CMsg::Id keybind_col[][2];
extern const CMsg::Id keybind_tab[];
extern const CMsg::Id joysetting_tab[];
#if defined(USE_PIAJOYSTICK) && defined(USE_JOYSTICKBIT)
extern const CMsg::Id joysetting_opts[Config::PIAJOY_CONN_TO_MAX + 1];
#endif
extern const CMsg::Id keybind_btn[];
extern const CMsg::Id keybind_combi[];

extern const CMsg::Id joypad_axis[];

extern const struct st_window_size {
	CMsg::Id msg_id;
	int percent;
} window_size[];

}; /* namespace LABELS */

#endif /* LABELS_H */

